<?php
session_start();
if (!isset($_SESSION['admin_logged_in'])) {
    // Build absolute path to admin login so includes called from other locations (e.g., includes/crud.php)
    $scriptName = $_SERVER['SCRIPT_NAME'] ?? '';
    $adminPos = strpos($scriptName, '/admin/');
    if ($adminPos !== false) {
        $appBase = substr($scriptName, 0, $adminPos);
    } else {
        $adminPos = strpos($scriptName, '/admin');
        if ($adminPos !== false) {
            $appBase = substr($scriptName, 0, $adminPos);
        } else {
            // fallback to parent directory of script
            $appBase = rtrim(dirname($scriptName), '/');
        }
    }
    if ($appBase === '') $appBase = '';
    // Ensure leading slash
    $loginPath = $appBase . '/admin/login.php';
    header('Location: ' . $loginPath);
    exit;
}
